/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogMarkerBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.HighBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.LowBlock;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.VirtualOutputBlock;
import DE.siemens.ad.logo.model.hardware.Logo4;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.UDFParameterItem;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WiringDiagramUDF
extends WiringDiagram {
    private static final long serialVersionUID = 7383538022542342571L;
    private UDFBlock fUDFBlock = new UDFBlock();
    private Vector<Block> fInputBlocks;
    private Vector<Block> fOutputBlocks;

    public WiringDiagramUDF(Hardware hardware) {
        super(hardware);
        this.initUDFBlock();
        this.fUDFBlock.setIdentifier("UDF");
    }

    protected void init() {
    }

    public UDFBlock getUDFBlock() {
        return this.fUDFBlock;
    }

    public UDFBlock initUDFBlock() {
        this.fUDFBlock.getBlocks().clear();
        this.fUDFBlock.getBlocks().addAll(this.getBlocks());
        this.fUDFBlock.initInConnectors4EditMode(this.getInConnectorBlocks());
        this.fUDFBlock.initOutConnectors4EditMode(this.getOutConnectorBlocks());
        return this.fUDFBlock;
    }

    public UDFBlock initUDFBlock4UseMode() {
        this.fUDFBlock.getBlocks().clear();
        for (int i = 0; i < this.getBlocks().size(); ++i) {
            Block blk = (Block)this.getBlocks().get(i);
            if (blk.getNumberType() == 6 || blk.getNumberType() == 7 || blk.getNumberType() == 11 || blk.getNumberType() == 13) continue;
            this.fUDFBlock.getBlocks().add(blk);
        }
        this.fUDFBlock.initInConnectors4UseMode(this.getInConnectorBlocks());
        this.fUDFBlock.initOutConnectors4UseMode(this.getOutConnectorBlocks());
        return this.fUDFBlock;
    }

    @Override
    public boolean canConnectWithoutRecursion(OutBlockConnector outConnector, InBlockConnector inConnector) {
        Block inputBlock = inConnector.getOwner();
        Block outputBlock = outConnector.getOwner();
        if (inputBlock instanceof UDFBlock || outputBlock instanceof UDFBlock) {
            return true;
        }
        return super.canConnectWithoutRecursion(outConnector, inConnector);
    }

    public Vector<Block> getInConnectorBlocks() {
        if (this.fInputBlocks == null) {
            this.fInputBlocks = new Vector();
        }
        return this.fInputBlocks;
    }

    public Vector<Block> getOutConnectorBlocks() {
        if (this.fOutputBlocks == null) {
            this.fOutputBlocks = new Vector();
        }
        return this.fOutputBlocks;
    }

    @Override
    public void setModified(boolean newModified) {
        super.setModified(newModified);
    }

    @Override
    public Block createBlock(int opcode, int blockNumber) throws IllegalArgumentException {
        ConstantBlock block = null;
        if (((Logo4)this.getHardware()).getOpcodeCO("Input", 0) == opcode) {
            block = new InputBlock();
        }
        if (((Logo4)this.getHardware()).getOpcodeCO("AnalogInput", 0) == opcode) {
            block = new AnalogInputBlock();
        }
        if (((Logo4)this.getHardware()).getOpcodeCO("Output", 0) == opcode) {
            block = new OutputBlock();
        }
        if (((Logo4)this.getHardware()).getOpcodeCO("AnalogOutput", 0) == opcode) {
            block = new AnalogOutputBlock();
        }
        if (((Logo4)this.getHardware()).getOpcodeCO("AnalogMarker", 0) == opcode) {
            block = new AnalogMarkerBlock();
        }
        if (((Logo4)this.getHardware()).getOpcodeCO("Marker", 0) == opcode) {
            block = new MarkerBlock();
        }
        if (((Logo4)this.getHardware()).getOpcodeCO("High", 0) == opcode) {
            block = new HighBlock();
        }
        if (((Logo4)this.getHardware()).getOpcodeCO("Low", 0) == opcode) {
            block = new LowBlock();
        }
        if (((Logo4)this.getHardware()).getOpcodeCO("Low", 0) == opcode) {
            block = new LowBlock();
        }
        if (((Logo4)this.getHardware()).getOpcodeCO("VirtualOutput", 0) == opcode) {
            block = new VirtualOutputBlock();
        }
        if (block != null) {
            this.addBlock(block);
            block.changeNumber(blockNumber);
            return block;
        }
        return super.createBlock(opcode, blockNumber);
    }

    @Override
    protected void changeNumber(int numberType, int oldNumber, int newNumber) throws IllegalArgumentException {
        if (numberType != -1) {
            int[] resourceArr = this.getNumberResource(numberType);
            if (resourceArr[newNumber - 1] == 2) {
                throw new IllegalArgumentException("New blocknumber is already allocated.");
            }
            if (oldNumber > 0) {
                resourceArr[oldNumber - 1] = 0;
            }
            resourceArr[newNumber - 1] = 2;
        }
    }

    @Override
    public Block getBlock(int opcode, int blockNumber) {
        Block result = null;
        Block block = null;
        Enumeration enumeration = this.getBlocks().elements();
        while (enumeration.hasMoreElements()) {
            block = (Block)enumeration.nextElement();
            if (block.getOpcode(block.getHardware(), 0) != opcode || block.getNumber() != blockNumber) continue;
            result = block;
            break;
        }
        return result;
    }

    @Override
    public void deleteBlock(Block block) {
        super.deleteBlock(block);
        this.verifyUDFParameterReferences(block);
    }

    protected void verifyUDFParameterReferences(Block deletedBlock) {
        UDFBlockParameter udfParameter;
        BlockParameter blockParameter = deletedBlock.getParameter();
        if (blockParameter != null && !blockParameter.getParameterItems().getPublicParameterItemList().isEmpty() && (udfParameter = (UDFBlockParameter)this.fUDFBlock.getParameter()) != null) {
            Iterator parameterItems = udfParameter.getParameterItems().iterator();
            while (parameterItems.hasNext()) {
                UDFParameterItem parameterItem = (UDFParameterItem)parameterItems.next();
                if (parameterItem.getSourceParameterItem().getParameter().getBlock() != deletedBlock) continue;
                parameterItems.remove();
            }
        }
    }

    public void setUDFBlock(UDFBlock udfBlock) {
        this.fUDFBlock = udfBlock;
        this.getBlocks().removeAllElements();
        this.getBlocks().addAll(this.fUDFBlock.children);
        this.getBlocks().addAll(this.getInConnectorBlocks());
        this.getBlocks().addAll(this.getOutConnectorBlocks());
    }

    @Override
    public Hashtable getErrors() {
        Hashtable dict = super.getErrors();
        if (this.getBlocks().isEmpty()) {
            dict.put("msg.noBlocks", "msg.noBlocks");
        }
        return dict;
    }

    @Override
    public int[] getFreeNumbers(int type) {
        int[] nums = super.getFreeNumbers(type);
        if (type == 10) {
            int[] markerNumbers = new int[nums.length];
            int numCnt = 0;
            for (int i = 0; i < nums.length; ++i) {
                if (nums[i] == 8 || nums[i] == 25 || nums[i] == 26 || nums[i] == 27) continue;
                markerNumbers[numCnt++] = nums[i];
            }
            int[] markerFreeNums = new int[numCnt];
            System.arraycopy(markerNumbers, 0, markerFreeNums, 0, numCnt);
            return markerFreeNums;
        }
        return nums;
    }

    @Override
    public int[] getNumberResource(int resourceType) {
        int[] resourceArr = super.getNumberResource(resourceType);
        if (resourceType == 10) {
            resourceArr[7] = 2;
            resourceArr[24] = 2;
            resourceArr[25] = 2;
            resourceArr[26] = 2;
        }
        return resourceArr;
    }

    @Override
    public int[] getUsedResources() {
        int[] resourceConsumption = super.getUsedResources();
        resourceConsumption[10] = resourceConsumption[10] + 4;
        return resourceConsumption;
    }
}

